/*************************************************************/
/***  L'3 - SDD - TP 1 - Listes chanes                   ***/
/*************************************************************/

#include <iostream>
#include <sstream>
#include <string>
#include <stdlib.h>

using namespace std;


/******************************************************************************
 DEFINITION D'UNE LISTE D'ENTIERS
 ******************************************************************************/

typedef struct maillon {
	int info;
	struct maillon* succ;
	struct maillon* pred;
} maillon;

typedef maillon* liste;

#define NUTIL ((maillon*)(-1))

/******************************************************************************
 FONCTIONS UTILITAIRES ET EXEMPLE
 ******************************************************************************/

/**
 * Convertit un tableau d'entiers en une liste simplement ou doublement
 * chane, linaire ou circulaire.
 *
 * Paramtre n : le nombre d'lments de t.
 * Paramtre t : tableau d'entiers  convertir.
 * Paramtre d : vrai si la liste doit tre doublement chane; dfaut : faux.
 * Paramtre c : vrai si la liste doit tre circulaire; dfaut : faux.
 *
 * Retourne : la liste quivalente  t.
 */
liste listet(int n, const int t[], bool d = false, bool c = false) {
	if (t == NULL || n == 0) {
		return NULL;
	}
	maillon* m = new maillon;
	m->info = t[0];
	liste l = m;
	for (int i = 1; i < n; i++) {
		m->succ = new maillon;
		m->succ->info = t[i];
		m->succ->pred = (d ? m : NUTIL);
		m = m->succ;
	}
	m->succ = (c ? l : NULL);
	l->pred = (d ? (c ? m : NULL) : NUTIL);
	return l;
}

/**
 * Reprsente une liste sous forme d'une chane de caractres. La liste peut
 * tre simplement ou doublement chane, linaire ou circulaire.
 *
 * Paramtre l : liste  reprsenter.
 *
 * Retourne : la chane reprsentant l.
 */
string chainel(liste l) {
	if (l == NULL) {
		return ".";
	}
	ostringstream r;
	if (l->pred != NUTIL) {
	    r << (l->pred == NULL ? "|" : "<");
	}
	maillon* c = l;
	do {
		r << "[" << c->info << "]";
		if (c->succ == NULL || c->succ == l) {
		    break;
		}
        if (c->succ->pred != NUTIL) {
            r << (c->succ->pred == c ? "<" : "?");
		}
		r << "->";
		c = c->succ;
	} while (true);
	r << (c->succ == NULL ? "|" : ">");
	return r.str();
}

/**
 * Dtermine la longueur d'une liste linaire ou circulaire.
 *
 * Paramtre l : liste  examiner.
 *
 * Retourne : la longueur de l.
 */
int longueur(liste l) {
	if (l == NULL) {
		return 0;
	}
	int n = 0;
	maillon* m = l;
	do {
		n += 1;
		m = m->succ;
	} while (m != NULL && m != l);
	return n;
}


/******************************************************************************
 1- FONCTIONS A DEVELOPPER - Parcours de listes
 ******************************************************************************/

/**
 * Dtermine le nombre d'occurrences d'un lment dans une liste linaire.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste  examiner.
 * Paramtre e : lment  compter.
 *
 * Retourne : le nombre d'occurrences de e dans l.
 */
int occurrences(liste l, int e) {
	throw "non traite";
}

int occurrences_rec(liste l, int e) {
	throw "non traite";
}

/**
 * Dtermine la position de la premire occurrence d'un lment dans une liste
 * linaire. La position du maillon de tte est 1.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste  examiner.
 * Paramtre e : lment  trouver.
 *
 * Retourne : la position de la premire occurrence de e dans l ou 0 si e n'est
 * pas dans l.
 */
int position(liste l, int e) {
	throw "non traite";
}

int position_rec(liste l, int e) {
	throw "non traite";
}

/**
 * Dtermine si une liste simplement chane linaire est trie par ordre
 * croissant de ses lments.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste  examiner.
 *
 * Retourne : 1 si la liste est trie par ordre croissant de ses lments et
 * 0 sinon.
 */
int estTriee(liste l) {
	throw "non traite";
}

int estTriee_rec(liste l) {
	throw "non traite";
}


/******************************************************************************
 2- FONCTIONS A DEVELOPPER - Modifications de listes
 ******************************************************************************/

/**
 * Insre un lment dans une liste doublement chane linaire aprs une
 * position donne. Si la position spcifie est 0, l'insertion se fait en
 * tte de liste.
 *
 * Paramtre l : liste  modifier.
 * Paramtre p : position aprs laquelle Insrer.
 * Paramtre e : lment  Insrer.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int inserer(liste* l, int p, int e) {
	throw "non traite";
}

/**
 * Supprime d'une liste doublement chane linaire l'lment situ  une
 * position donne. Si la position est suprieure  la longueur de la liste,
 * le dernier maillon est supprim.
 *
 * Paramtre l : liste  modifier.
 * Paramtre p : position de l'lment  supprimer.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int supprimer(liste* l, int p) {
	throw "non traite";
}

/**
 * Supprime toutes les occurrences d'un lment dans une liste simplement
 * chane linaire.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste dans laquelle supprimer e.
 * Paramtre e : lment  supprimer dans l.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int supprimero(liste* l, int e) {
	throw "non traite";
}

int supprimero_rec(liste* l, int e) {
	throw "non traite";
}

/**
 * Inverse l'ordre des lments d'une liste simplement chane linaire.
 * L'inversion se fait en place, sans recopie des maillons de la liste.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste  inverser.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int inverser(liste* l) {
	throw "non traite";
}

int inverser_rec(liste* l) {
	throw "non traite";
}

/**
 * Cre une liste doublement chane linaire, copie inverse d'une liste
 * simplement chane linaire. La liste initiale n'est pas modifie.
 *
 * Paramtre l : liste  inverser.
 *
 * Retourne : la liste doublement chane linaire copie inverse de l.
 */
liste copierInverser(liste l) {
	throw "non traite";
}

/**
 * Concatne deux listes simplement chanes linaires entre elles.
 *
 * Paramtre l1 : liste  laquelle concatener l2.
 * Paramtre l2 : liste  concatener  l1.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int concatener(liste* l1, liste l2) {
	throw "non traite";
}

/**
 * Dtruit une liste chane linaire. L'ensemble de ses maillons est libr.
 *
 * La fonction doit tre implmente en itratif et en rcursif.
 *
 * Paramtre l : liste  dtruire.
 *
 * Retourne : 1 si succs ou 0 sinon (un paramtre est incorrect).
 */
int detruire(liste* l) {
	throw "non traite";
}

int detruire_rec(liste* l) {
	throw "non traite";
}


/******************************************************************************
 PROGRAMME DE TEST - Tester ici chaque fonction developpe
 ******************************************************************************/

int main(int argc, char* argv[]) {

	// AUTEURS ( complter)
	cout << "AUTEURS : Nom1, Nom2 \n" <<endl;

	// TEST longueur (exemple)
	cout << "TEST longueur" << endl;
	liste l = listet(0, NULL);
	cout << "longueur( " << chainel(l) << " ) = " << longueur(l) << endl;
	l = listet(1, (const int[]) {1});
	cout << "longueur( " << chainel(l) << " ) = " << longueur(l) << endl;
	l = listet(3, (const int[]) {1, 2, 3});
	cout << "longueur( " << chainel(l) << " ) = " << longueur(l) << endl;
	l = listet(1, (const int[]) {1}, false, true);
	cout << "longueur( " << chainel(l) << " ) = " << longueur(l) << endl;
	l = listet(3, (const int[]) {1, 2, 3}, false, true);
	cout << "longueur( " << chainel(l) << " ) = " << longueur(l) << endl;

	// TEST occurrences


	// TEST occurrence_rec


	// ...

	return 0;
}
