// Auteur : Mathieu G.
// Site : http://www.design-patterns.fr
// Licence : GNU General Public License

package multiton;

//Classe reprsentant un compte bancaire simpliste.
public class CompteBancaire 
{
	private int numero;// Numro du compte.
	private double solde;// Argent disponible sur le compte.

	// Constructeur d'un CompteBancaire  partir de son numro.
	public CompteBancaire(int numero)
	{
		this.numero=numero;
		this.solde=0.0;
	}
	
	// Mthode qui permet de dposer de l'argent sur le compte.
	public void deposerArgent(double depot)
	{
		if(depot>0.0)
		{       
			solde+=depot;// On ajoute la somme dpose au solde.
			Journalisation.getInstance("informations").ajouterLog("Dpt de "+depot+" sur le compte "+numero+".");
		}
		else
		{
			Journalisation.getInstance("erreurs").ajouterLog("/!\\ Dpt d'une valeur ngative impossible ("+numero+").");
		}
	}

	// Mthode qui permet de retirer de l'argent sur le compte.
	public void retirerArgent(double retrait)
	{
		if(retrait>0.0)
		{
			if(solde>=retrait)
			{
				solde-=retrait;// On retranche la somme retire au solde.
				Journalisation.getInstance("informations").ajouterLog("Retrait de "+retrait+" sur le compte "+numero+".");
			}
			else
			{
				Journalisation.getInstance("erreurs").ajouterLog("/!\\ La banque n'autorise pas de dcouvert ("+numero+").");
			}
		}
		else
		{
			Journalisation.getInstance("erreurs").ajouterLog("/!\\ Rerait d'une valeur ngative impossible ("+numero+").");
		}
	}
}
 