import java.util.*;
import java.io.*;

class TreeNode2 implements Serializable {
  Vector children;
  TreeNode2 parent;
  String name;
  transient Date date;

  public TreeNode2(String s) {
    children = new Vector(5);
    name = s;
    InitDate();
  }
  private void InitDate () {
    date = new Date();
  }
  
  public synchronized void setChildren (TreeNode2[] list) {
    children.removeAllElements();
    int size = list.length;
    for (int i=0;i<size;i++) {
      addChild (list[i]);
    }
  }
  public void setChildren (TreeNode2 element, int position) {
    children.setElementAt (element, position);
    element.parent = this;
  }
  public synchronized TreeNode2[] getChildren () {
    int size = children.size();
    TreeNode2 tree[] = new TreeNode2[size];
    for (int i=0;i<size;i++) {
      tree[i] = (TreeNode2)children.elementAt (i);
    }
    return tree;
  }
  public TreeNode2 getChildren (int position) {
    return (TreeNode2)children.elementAt (position);
  }
  public void addChild (TreeNode2 n) {
    children.addElement(n);
    n.parent = this;
  }

  public String toString() {
    Enumeration e = children.elements();
    StringBuffer buff = new StringBuffer(100);
    buff.append("[ " +  name + " : ");
    while(e.hasMoreElements()) {
      buff.append(e.nextElement().toString());
    }
    buff.append(" ] ");
    buff.append (date.toString());

    return buff.toString();
  }
  public static void main (String args[]) {
    TreeNode2 root = new TreeNode2("root");
    TreeNode2 left, right, both;
    root.addChild(left = new TreeNode2("left child"));
    root.addChild(right = new TreeNode2("right child"));
    both = new TreeNode2 ("problem child");
    left.addChild (both);
    right.addChild (both);
    System.out.println (root);
    try {
      FileOutputStream fOut = new FileOutputStream("test.out");
      ObjectOutput out = new ObjectOutputStream(fOut);
      out.writeObject(root);
      out.flush();
      out.close();
      FileInputStream fIn = new FileInputStream("test.out");
      ObjectInputStream in = new ObjectInputStream(fIn);
      TreeNode2 n = (TreeNode2)in.readObject();
      in.close();
      System.out.println ("After: " + n);
    } catch (Exception e) {
      System.out.println ("Whoops");
      e.printStackTrace();
    }
  }

  private void writeObject(ObjectOutputStream s)
      throws IOException {
        s.defaultWriteObject();
  }
  private void readObject(ObjectInputStream s)
      throws ClassNotFoundException, IOException {
         s.defaultReadObject();
          InitDate();

  }
}
