import java.util.*;
import java.io.*;

class TreeNode1 implements Serializable {
  Vector children;
  TreeNode1 parent;
  String name;
  transient Date date;


  public TreeNode1(String s) {
    children = new Vector(5);
    name = s;
    InitDate();
  }
  private void InitDate () {
    date = new Date();
  }
  
  public synchronized void setChildren (TreeNode1[] list) {
    children.removeAllElements();
    int size = list.length;
    for (int i=0;i<size;i++) {
      addChild (list[i]);
    }
  }
  public void setChildren (TreeNode1 element, int position) {
    children.setElementAt (element, position);
    element.parent = this;
  }
  public synchronized TreeNode1[] getChildren () {
    int size = children.size();
    TreeNode1 tree[] = new TreeNode1[size];
    for (int i=0;i<size;i++) {
      tree[i] = (TreeNode1)children.elementAt (i);
    }
    return tree;
  }
  public TreeNode1 getChildren (int position) {
    return (TreeNode1)children.elementAt (position);
  }
  public void addChild (TreeNode1 n) {
    children.addElement(n);
    n.parent = this;
  }

  public String toString() {
    Enumeration e = children.elements();
    StringBuffer buff = new StringBuffer(100);
    buff.append("[ " +  name + " : ");
    while(e.hasMoreElements()) {
      buff.append(e.nextElement().toString());
    }
    buff.append(" ] ");


    return buff.toString();
  }
  public static void main (String args[]) {
    TreeNode1 root = new TreeNode1("root");
    TreeNode1 left, right, both;
    root.addChild(left = new TreeNode1("left child"));
    root.addChild(right = new TreeNode1("right child"));
    both = new TreeNode1 ("problem child");
    left.addChild (both);
    right.addChild (both);
    System.out.println (root);
    try {
      FileOutputStream fOut = new FileOutputStream("test.out");
      ObjectOutput out = new ObjectOutputStream(fOut);
      out.writeObject(root);
      out.flush();
      out.close();
      FileInputStream fIn = new FileInputStream("test.out");
      ObjectInputStream in = new ObjectInputStream(fIn);
      TreeNode1 n = (TreeNode1)in.readObject();
      in.close();
      System.out.println ("After: " + n);
    } catch (Exception e) {
      System.out.println ("Whoops");
      e.printStackTrace();
    }
  }
}
