package landsbeans;

import java.util.EventObject;
import java.util.Vector;



interface HireListener extends java.util.EventListener
{
  abstract public void hired (HireEvent e);
}


class HireEvent extends EventObject
{
  private long hireDate;

  public HireEvent (Object source)
  {
    super (source);
    hireDate = System.currentTimeMillis();
    System.out.println(((Hire)source).getName() + " cre l'vnement");
  }

  public HireEvent (Object source, long hired)
  {
    super (source);
    hireDate = hired;
    System.out.println(((Hire)source).getName()  + " cre l'vnement");
  }

  public long getHireDate ()
  {
	  return hireDate;
  }
}

// la source ou l'metteur de l'vnement
public class Hire
{
  private String name;

  private Vector hireListeners = new Vector();

  public Hire (String name)
  {
    this.name = name;
  }

  public String getName ()
  {
    return name;
  }

  public synchronized void addHireListener (HireListener l)
	{
  			hireListeners.addElement (l);
	}

  public synchronized void removeHireListener (HireListener l)
	{
  			hireListeners.removeElement (l);
	}

  // la notification
  protected void notifyHired ()
  {
    Vector v;

    // cration de l'vnement
    HireEvent hireEvent = new HireEvent (this);

    // copie du vecteur de listeners, il ne changera pas
    //pendant l'envoi de l'vnement
    synchronized (this)
    {
  	  v = (Vector)hireListeners.clone();
    }

    //activation de la mthode pour les auditeurs
    for (int i = 0; i < v.size(); i++)
    {
      HireListener hireListener = (HireListener)v.elementAt (i);

      hireListener.hired(hireEvent);
    }
  }


  public static void main ( String [] args )
  {
    Hire hire = new Hire("Landsnet Consultant");

    Employe landschoot = new Employe (hire, "Michel Landschoot");
    Employe portier = new Employe (hire, "Delphine Portier");
    Employe jack = new Employe (hire, "Jack l'Eventreur");

    landschoot.abonne();
    portier.abonne();
    jack.abonne();
    hire.notifyHired();

   portier.desabonne();
   hire.notifyHired();
  }
}

// les auditeurs pour une embauche
class Employe
{
  private Hire hire;
  // on conserve une rfrence sur l'auditeur anonyme.
  // car les auditeurs ne sont plus rellement des instances de Employe
  // mais des instances de type HireListener
  private HireListener ecouteurAnonyme;

  private String name;

  public Employe (Hire hire, String name)
  {
    this.hire = hire;
    this.name = name;
  }

  // l'auditeur s'enregistre auprs de la source
  public void abonne ()
  {
    hire.addHireListener( ecouteurAnonyme = new HireListener() {
             // mthode lance lorsque la source notifie l'vnement  ses auditeurs
             public void hired (HireEvent event)
             {
              System.out.println("notification de : " + name +
                        "  " + event.getHireDate());
              }
    });
  }

  // encore possible car Employe connat l'auditeur abonn
   public void desabonne ()
  {
    hire.removeHireListener(this.ecouteurAnonyme);
  }

}

/*
Pierre a un nouveau salaire : 200000
l'ancien salaire tait : 100000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 100000
Pierre a un nouveau salaire : 300000
l'ancien salaire tait : 200000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 200000
Jeanne est informe du nouveau salaire de Pierre
*/
