package landsbeans;

import java.awt.event.*;
import java.io.Serializable;

// Beans!
import java.beans.*;


public class EmployeeVeto implements PropertyChangeListener,
					VetoableChangeListener
{
int salary = 100000;

public int getSalary () { return salary; }

// pour dclencher les vnements
private PropertyChangeSupport changesListeners = new PropertyChangeSupport (this);


private VetoableChangeSupport vetoesListeners =  new VetoableChangeSupport (this);


public EmployeeVeto()
{

}

public void addPropertyChangeListener (PropertyChangeListener p)
{
  changesListeners.addPropertyChangeListener (p);
}

public void removePropertyChangeListener (PropertyChangeListener p)
{
  changesListeners.removePropertyChangeListener (p);
}

public void addVetoableChangeListener (VetoableChangeListener v)
{
  vetoesListeners.addVetoableChangeListener (v);
}

public void removeVetoableChangeListener (VetoableChangeListener v)
{
  vetoesListeners.removeVetoableChangeListener (v);
}


public void setSalary (int salary) throws PropertyVetoException
{
  int oldSalary = this.salary;

  vetoesListeners.fireVetoableChange ("salary", oldSalary, salary);
  this.salary = salary;
  changesListeners.firePropertyChange ("salary", oldSalary, this.salary);
}


public void propertyChange(PropertyChangeEvent e)
{
	if ( e.getSource() == this && e.getPropertyName().equals("salary") )
	{
			Object o = e.getNewValue();

			int newSalary;

			if ( o == null )
				newSalary = this.getSalary();
			else
				newSalary = ((Integer) o).intValue();

			System.out.println("nouveau salaire : " + newSalary);
	}
}


public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException
{
    if ( e.getSource() != this && e.getPropertyName().equals("salary") )
    {
      Object o = e.getNewValue();
      Object oa = e.getOldValue();

      int newSalary;
      int ancSalary;

      if ( o == null )
        newSalary = this.getSalary();
      else
        newSalary = ((Integer) o).intValue();


      if ( oa == null )
        ancSalary = this.getSalary();
      else
        ancSalary = ((Integer) oa).intValue();

      if (ancSalary > newSalary)
      {
          System.out.println("Interdit de changer cette proprit");
          System.out.println("Le nouveau Salaire " + newSalary +
                    " doit etre superieur  l'ancien " + ancSalary );
          throw new PropertyVetoException("Veto exception",e);
      }
    }
}

  public static void main(String [] args)
  {
      EmployeeVeto e1 = new EmployeeVeto();
      EmployeeVeto e2 = new EmployeeVeto();

      e1.addPropertyChangeListener(e1);
      e1.addVetoableChangeListener(e2);

      try
      {
        e1.setSalary(100000);
        e1.setSalary(200000);
        e1.setSalary(150000);
      }
      catch ( PropertyVetoException e)
      {
          System.out.println(e.getMessage());
      }

   }
}

/*
Pierre a un nouveau salaire : 200000
l'ancien salaire tait : 100000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 100000
Pierre a un nouveau salaire : 300000
l'ancien salaire tait : 200000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 200000
Jeanne est informe du nouveau salaire de Pierre
*/
