package landsbeans;

import java.awt.event.*;
import java.io.Serializable;

// Beans!
import java.beans.*;

public class Employee implements PropertyChangeListener

{
int salary = 100000;
String name;

public int getSalary () {   return salary; }

// pour dclencher les vnements
private PropertyChangeSupport changesListeners = new PropertyChangeSupport (this);


public Employee(String name)
{
  this.name = name;
  this.addPropertyChangeListener(this);

}

public void addPropertyChangeListener (PropertyChangeListener p)
{
  changesListeners.addPropertyChangeListener (p);
}

public void removePropertyChangeListener (PropertyChangeListener p)
{
  changesListeners.removePropertyChangeListener (p);
}

public String toString() { return name; }


// Quand le salaire change via setSalary, il faut regarder si la
// valeur de la proprit a chang et si c'est le cas notifier
// tous les auditeurs

public void setSalary (int salary)
{
    Integer oldSalary = new Integer (this.salary);
    this.salary = salary;
    changesListeners.firePropertyChange ( "salary", oldSalary, new Integer(this.salary));
}

// la mthode des auditeurs lance lors de la notification
public void propertyChange(PropertyChangeEvent e)
{
	if ( e.getSource() == this &&  e.getPropertyName().equals("salary") )
	{
			Object o = e.getNewValue();

			int newSalary;

			if ( o == null )
        newSalary = this.getSalary();
			else
				newSalary = ((Integer) o).intValue();

			System.out.println(e.getSource() + " a un nouveau salaire : " + newSalary);

	}
  else
  	System.out.println(this + " est inform" + " du nouveau salaire de " + e.getSource());

  System.out.println("l'ancien salaire tait : " + ((Integer) e.getOldValue()).intValue());

}




  public static void main(String [] args)
  {
      Employee e1 = new Employee("Pierre");

      Employee e2 = new Employee("Paul");

      e1.addPropertyChangeListener(e2);

      e1.setSalary(100000);
      e1.setSalary(200000);

      Epouse femme = new Epouse ("Jeanne");
      e1.addPropertyChangeListener(femme);
      e1.setSalary(300000);
  }
}


class Epouse implements PropertyChangeListener

{

String name;



public Epouse(String name)
{
  this.name = name;
}


public String toString() { return name; }


// la mthode des auditeurs lance lors de la notification
public void propertyChange(PropertyChangeEvent e)
{

  	System.out.println(this + " est informe" + " du nouveau salaire de " + e.getSource());

}
}

/*
Pierre a un nouveau salaire : 200000
l'ancien salaire tait : 100000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 100000
Pierre a un nouveau salaire : 300000
l'ancien salaire tait : 200000
Paul est inform du nouveau salaire de Pierre
l'ancien salaire tait : 200000
Jeanne est informe du nouveau salaire de Pierre
*/

