import java.io.*;

public class Customer implements Serializable
{

	// data members
	private String name;
	private int age;

	// constructors
	public Customer()
	{
		this("Nas", 22);
	}

	public Customer(String theName, int theAge)
	{
		name = theName;
    age = theAge;
	}

	// methods
	public String toString()
	{
		String temp;

		temp  = "Name: " + name + "\n";
		temp += "Age:  " + age + "\n";

		return temp;
	}

	public void save(String fileName) throws IOException
	{
		FileOutputStream fos;
		ObjectOutputStream oos;

		fos = new FileOutputStream(fileName);
		oos = new ObjectOutputStream(fos);

		// write the object
		oos.writeObject(this);
		oos.flush();

		oos.close();
	}

	public static Customer load(String fileName) throws IOException, ClassNotFoundException
	{
		FileInputStream fis;
		ObjectInputStream ois;

		Customer tempCustomer = null;

		fis = new FileInputStream(fileName);
		ois = new ObjectInputStream(fis);

		// read the object
		tempCustomer = (Customer) ois.readObject();

		ois.close();

		return tempCustomer;

	}

}