package zoo;

import java.util.LinkedList;

/**
 * Container d'animaux
 */
public class Zoo {

    private LinkedList<Animal> zooList;

    /**
     * On alloue la mémoire pour zooList
     */
    public Zoo() {
        zooList = new LinkedList<Animal>();
    }

    /**
     * Ajout d'un animal
     * @param nouvelleBete animal à ajouter
     */
    public void ajouter(Animal nouvelleBete) {
        zooList.add(nouvelleBete);
    }

    /**
     * Affichage du zoo
     * @return String du zoo
     */
    @Override
    public String toString() {
        StringBuilder returnString = new StringBuilder();
        for(int i = 0; i < zooList.size(); i++) {
            returnString.append(zooList.get(i));
            returnString.append(System.getProperty("line.separator")); // Retour à la ligne
            returnString.append(zooList.get(i).manger());
            returnString.append(System.getProperty("line.separator"));
        }

        return returnString.toString();
    }
}
