package zoo;

import java.util.Arrays;

/**
 * Une PolyLine désigne une droite définie par plusieurs Points.
 */
public class PolyLine {

    //private final Point[] points; final ne fonctionne pas
    private Point[] points;

    /**
     * Constructeur de la PolyLine; initialisation du tableau de Points
     * @param nombrePoints nombre de points maximal
     */
    public PolyLine(int nombrePoints) {
        points = new Point[nombrePoints]; // 2 points maximum
    }

    /* Version de add sans contrôle de taille
    public void add(Point p) {
        for (int i = 0; i < points.length; i++) {
            if (points[i] == null) {
                System.out.println("Insertion en position " + i);
                points[i] = p;
            }
        }
    }
     */

    /**
     * Ajout de point en fin de tableau s'il reste de la place
     * @param p point à ajouter
     * @return true/false suivant si le point est inséré
     */
    public boolean add(Point p) {
        if (p != null) {
            for (int i = 0; i < pointCapacity(); i++) {
                if (points[i] == null) {
                    System.out.println("Insertion de " + p.toString() + " en position " + i); // on pourrait utiliser StringBuilder
                    points[i] = p;
                    return true;
                }
            }
            System.out.println("Impossible d'insérer le point " + p.toString() + ", tous les espaces sont déjà occupés");
        }
        else {
            System.out.println("p ne doit pas etre nul");
        }
        return false;
    }

    /**
     * Renvoie la capacité maximum du tableau de points
     * @return capacité maximum du tableau de points
     */
    public int pointCapacity() {
        return points.length;
    }

    /**
     * Compte le nombre de points dans le tableau
     * On pourrait réécrire add avec cette méthode
     * @return nombre de points dans le tableau
     */
    public int pointCount(){
        int count = 0;

        for (int i = 0; i < pointCapacity(); i++) {
            if (points[i] != null) {
                count++;
            }
        }

        return count;
    }

    /**
     * Surcharge de toString
     * Affichage du contenu du tableau de points
     * @return PolyLine{points=...}
     */
    @Override
    public String toString() {
        return "PolyLine{" +
                "points=" + Arrays.toString(points) +
                '}';
    }

    /**
     * Vérification de l'existence d'un point dans le tableau
     * @param p Point à vérifier
     * @return true/false
     */
    public boolean contains(Point p) {
        if (p != null) {
            for (int i = 0; i < pointCapacity(); i++) {
                if (points[i] != null) {
                    if (p.isSameAs(points[i])) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
