package zoo;

/**
 * Création, affichage et vérification d'un point
 */
public class Point
{
    private final float x;
    private final float y;

    /**
     * Méthode main de Point
     * @param args Chaines de caractères
     */
    public static void main(String[] args)
    {
        Point p1 = new Point(0.0F, 0.0F);
        System.out.println(p1.x+" "+p1.y);

        Point p2 = new Point(0.0F, 0.0F);
        System.out.println(p1.equals(p2));

        Point p3 = new Point(4.5F, 3.6F);
        System.out.println(p3.toString());
    }

    /**
     * Constructeur de Point
     * @param x coordonnées x
     * @param y coordonnées y
     */
    public Point(final float x, final float y) { this.x = x ; this.y = y ; }

    /**
     * Constructeur de copie
     * @param p point à copier
     */
    public Point(final Point p) { this(p.x, p.y) ; }

    /**
     * Getter de X
     * @return coordonnées x
     */
    public float getX() { return x ; }

    /**
     * Getter de Y
     * @return coordonnées y
     */
    public float getY() { return y ; }

    /**
     * Vérifie si deux points sont identiques à partir de leur coordonnées
     * @param p Point à vérifier
     * @return true/false
     */
    public boolean isSameAs(final Point p)
    {
        return ((x == p.x) && (y == p.y));
    }

    /**
     * Surcharge equals
     * @param obj Point à vérifier
     * @return true/false
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Point other = (Point) obj;
        if (x != other.x)
            return false;
        if (y != other.y)
            return false;
        return true;
    }

    /**
     * Affichage du point
     * @return Point [x=..., y=...]
     */
    @Override
    public String toString() {
        return "Point [x=" + x + ", y=" + y + "]";
    }
}
