package tp6;

/**
 * Compte combien d'itérations sont faites en 100ms
 */
public class CounterBug implements Runnable {
    private boolean stop;

    /**
     * Utilisation de synchronized pour incrémenter le compteur
     */
    public void run() {
        int localCounter = 0;
        for (; ; ) {
            if (stop) {
                break;
            }
            synchronized (this) {
                localCounter++;
            }
        }
        System.out.println(localCounter);
    }

    /**
     * Arrêt du compteur
     */
    public void stop() {
        stop = true;
    }

    /**
     * Lancement et arrêt du compteur
     * @param args Arguments par défaut
     * @throws InterruptedException erreur en cas d'arrêt inopiné
     */
    public static void main(String[] args) throws InterruptedException {
        CounterBug counter = new CounterBug();
        Thread thread = new Thread(counter);
        thread.start();
        Thread.sleep(100);
        counter.stop();
        thread.join();
    }
}