package tp6;

/**
 * Première classe avec des threads, message d'arrêt
 */
public class HelloThreadJoin implements Runnable {
    /**
     * Action effectuée par les threads: boucle de 5000 itérations affichant le thread actuel et
     * le niveau du compteur
     */
    public void run() {
        for(int i=0;i<5000;i++)
            System.out.println("hello " + Thread.currentThread().getName() + " " + i);
    }

    /**
     * Lancement de 4 threads effectuant la tâche définie plus haut
     * Affichage d'un message quand les threads ont tous fini de s'exécuter
     * @param args Arguments par défaut
     */
    public static void main(String args[]) {
        Thread t0 = new Thread(new HelloThreadJoin());
        t0.setName("0");

        Thread t1 = new Thread(new HelloThreadJoin());
        t1.setName("1");

        Thread t2 = new Thread(new HelloThreadJoin());
        t2.setName("2");

        Thread t3 = new Thread(new HelloThreadJoin());
        t3.setName("3");

        t0.start();
        t1.start();
        t2.start();
        t3.start();

        // On vérifie que les threads ont bien fini de s'exécuter
        try{
            t0.join();
            t1.join();
            t2.join();
            t3.join();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        // Message de confirmation de fin d'exécution
        System.out.println("Les threads ont fini de s'exécuter");

    }
}
