package tp5partie1;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Test des réponses au clic via ActionEvent et AbstractAction
 * @author Adrien Poupa
 */
public class TestClicBis {

    public static void main(String[] args){

        /**
         * Boutons et leurs réponses
         * @param args arguments par défaut
         */
        JFrame fenetre = new JFrame();
        fenetre.setTitle("Test clic");
        fenetre.setSize(200, 200);

        Container contentPane = fenetre.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

        contentPane.add(new JButton(new AbstractAction("OK") {
            public void actionPerformed(ActionEvent e) {
                System.out.println("Test clic");
            }
        }));

        contentPane.add(new JButton(new AbstractAction("Un") {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Un*");
            }
        }));

        contentPane.add(new JButton(new AbstractAction("Deux") {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Deux*");
            }
        }));

        contentPane.add(new JButton(new AbstractAction("Trois") {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Trois*");
            }
        }));

        fenetre.setLocationRelativeTo(null);
        fenetre.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        fenetre.setVisible(true);
    }
}