package tp5partie1;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Test des réponses au clic via ActionListener
 * @author Adrien Poupa
 */
public class TestClic {
    private JFrame fenetre;

    /**
     * Boutons et leurs réponses
     * @param args arguments par défaut
     */
    public static void main(String[] args){

        // Création de la fenêtre
        JFrame fenetre = new JFrame();
        fenetre.setTitle("Test clic");
        fenetre.setSize(500, 200);

        // Création et écoute du bouton OK
        // Affiche Test clic dans la console quand cliqué
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("Test clic");
            }
        });

        // Création et écoute du bouton Un
        // Change le titre de la fenêtre quand cliqué
        JButton un = new JButton("Un");
        un.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Un*");
            }
        });

        // Création et écoute du bouton Deux
        // Change le titre de la fenêtre quand cliqué
        JButton deux = new JButton("Deux");
        deux.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Deux*");
            }
        });

        // Création et écoute du bouton Trois
        // Change le titre de la fenêtre quand cliqué
        JButton trois = new JButton("Trois");
        trois.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                fenetre.setTitle("*Trois*");
            }
        });


        button.setAlignmentX(Component.CENTER_ALIGNMENT);
        un.setAlignmentX(Component.CENTER_ALIGNMENT);
        deux.setAlignmentX(Component.CENTER_ALIGNMENT);
        trois.setAlignmentX(Component.CENTER_ALIGNMENT);

        Container contentPane = fenetre.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

        contentPane.add(button);
        contentPane.add(un);
        contentPane.add(deux);
        contentPane.add(trois);
        fenetre.setLocationRelativeTo(null);
        fenetre.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        fenetre.setVisible(true);
    }
}