package tp5partie1;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;

/**
 * Calcul d'une factorielle avec une IHM
 * @author Adrien Poupa
 */
public class Factorielle {
    /**
     * IHM pour le calcul d'une factoriele
     * @param args arguments par défaut
     */
    public static void main(String[] args){

        // Création de la fenêtre
        JFrame fenetre = new JFrame();
        fenetre.setTitle("Calcul d'une factorielle");
        fenetre.setSize(200, 200);

        // Création du bouton Calculer
        JButton button = new JButton("Calculer");
        button.setAlignmentX(Component.CENTER_ALIGNMENT);
        button.setToolTipText("Calcul de la factorielle");

        // Création du bouton de validation
        JTextField entry = new JTextField("Entrée");
        entry.setAlignmentX(Component.CENTER_ALIGNMENT);

        // Création du champ de texte résultat
        JTextField textField = new JTextField("Résultat");
        textField.setAlignmentX(Component.CENTER_ALIGNMENT);
        textField.setEnabled(false); // Désactivation
        textField.setBackground(Color.RED);

        // Ajout des blocs
        Container contentPane = fenetre.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

        // Gestion de l'affichage du résultat quand l'utilisateur clique sur "Calculer"
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                // Si l'entrée est bien numérique
                if (isNumeric(entry.getText())) {
                    long fact = Integer.parseInt(entry.getText()); // Récupération de l'entrée en long
                    if (entry.getText().equals(new String("5"))) { // Si l'entrée est à 5, on ne calcule pas (énoncé)
                        textField.setText("5!");
                    } else {
                        // Sinon, on renvoie le résultat du calcul de la factorielle
                        textField.setText(entry.getText() + "! = " + factorial(fact).toString());
                    }
                }
            }
        });

        contentPane.add(entry);
        contentPane.add(button);
        contentPane.add(textField);

        fenetre.setLocationRelativeTo(null);
        fenetre.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        fenetre.setVisible(true);
    }

    /**
     * Détermine si une chaîne de caractères est un nombre valide
     * @param str chaîne à évaluer
     * @return true/false
     */
    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; i++) {
            if (Character.isDigit(str.charAt(i)) == false) {
                return false;
            }
        }
        return true;
    }

    /**
     * Calcul de la factorielle avec BigInteger pour gérer de gros résultats
     * @param number factorielle à calculer
     * @return résultat du calcul
     */
    public static BigInteger factorial(long number)
    {
        int c;
        BigInteger inc = new BigInteger("1");
        BigInteger fact = new BigInteger("1");
        for (c = 1; c <= number; c++) {
            fact = fact.multiply(inc);
            inc = inc.add(BigInteger.ONE);
        }

        return fact;
    }
}
