package tp5partie1;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;

/**
 * Découvert des possibilités de Swing
 * @author Adrien Poupa
 */
public class Decouverte {
    /**
     * Création de la fenêtre à afficher
     * @param args paramètres par défaut
     */
    public static void main(String[] args){

        JFrame fenetre = new JFrame();
        fenetre.setTitle("Découverte");
        fenetre.setSize(500, 200);;

        // Création d'un bouton
        JButton button = new JButton("Bouton");
        button.setAlignmentX(Component.CENTER_ALIGNMENT); // Alignement
        button.setToolTipText("Aide contextuelle"); // Infobulle utilisateur
        button.setEnabled(false); // Désactivation du bouton
        button.setBackground(new Color(0, 47, 228)); // Fond du bouton
        button.setForeground(Color.RED); // Couleur du texte du bouton, visible uniquement si bouton activé

        // Création d'un champ de texte
        JTextField textField = new JTextField("textField");
        textField.setAlignmentX(Component.CENTER_ALIGNMENT);
        textField.setEnabled(false);

        Border border = BorderFactory.createLineBorder(Color.YELLOW, 2);

        // Création d'une zone de texte
        JTextArea textArea = new JTextArea("textArea");
        textArea.setAlignmentX(Component.CENTER_ALIGNMENT);
        textArea.setBorder(border); // Ajout d'une bordure

        // Container pour arranger la fenêtre
        Container contentPane = fenetre.getContentPane();
        // Les modules sont ajoutés centrés
        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

        contentPane.add(button);
        contentPane.add(textField);
        contentPane.add(textArea);
        fenetre.setLocationRelativeTo(null);
        fenetre.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        fenetre.setVisible(true);
    }
}
