package tp5partie1;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

/**
 * Ajout et suppression dynamique de boutons
 * @author Adrien Poupa
 */
public class Auditeurs {
    private static int i = 0;
    private static JFrame frame;

    /**
     * Retourne l'indice actuel de l'instance sous forme de String et l'incrémente
     * @return indice actuel en String
     */
    public static String getNext() {
        return Integer.toString(i++);
    }

    /**
     * Ecoute de l'action de suppression
     */
    static private ActionListener deleteAction = new ActionListener()
    {
        /**
         * Suppression d'un élément en particulier
         * @param ae ActionEvent contenant l'élément à supprimer
         */
        public void actionPerformed(ActionEvent ae)
        {
            JButton button = (JButton) ae.getSource();
            frame.remove(button);
            frame.revalidate();
            frame.repaint();
        }
    };

    /**
     * Création de la fenêtre, gestion de l'ajout dynamique, suppression dynamique et suppression totale
     * @param args arguments de base
     */
    public static void main(String[] args){

        frame = new JFrame("Ajout et suppression dynamique");
        frame.setLayout(new GridLayout(0, 1));

        // ArrayList contenant tous les boutons créés
        ArrayList<JButton> buttonContainer = new ArrayList<JButton>();

        // Ajout dynamique d'un bouton
        frame.add(new JButton(new AbstractAction("Add") {
            @Override
            public void actionPerformed(ActionEvent e) {
                String currentI = Auditeurs.getNext(); // Indice actuel
                JButton newButton = new JButton(currentI);
                buttonContainer.add(newButton); // Ajout du bouton au container
                newButton.addActionListener(deleteAction); // On attache de quoi supprimer le bouton plus tard
                frame.add(newButton); // Ajout du bouton
                frame.validate(); // Validation...
                frame.repaint(); // ... et mise à jour de la fenêtre
            }
        }));

        frame.add(new JButton(new AbstractAction("Reset") {
            @Override
            public void actionPerformed(ActionEvent e) {
                for (JButton b: buttonContainer) { // On parcourt tous les boutons
                    frame.remove(b); // Suppression du bouton
                }
                frame.validate(); // Validation...
                frame.repaint(); // ... et mise à jour de la fenêtre
            }
        }));

        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }
}
