package moyenneException;

/**
 * Utilisation de la classe de calcul d'une racine
 * @author Adrien Poupa
 */
public class UtiliseRacine {
    /**
     * Utilisation de la racine
     * @param argv arguments par défaut
     */
    public static void main(String[] argv) {

        try {
            // Pas d'argument: erreur
            if (argv.length <= 0) {
                throw new NumberFormatException("Il n'y a pas d'arguments");
            }
            Racine extracteur = new Racine(0.01);
            double operande = (Double.valueOf(argv[0])).doubleValue();
            double valeurRacine;
            valeurRacine = extracteur.racine(operande);
            System.out.println(valeurRacine);
            System.out.println("precision " + extracteur.getPrecision() + " , erreur =" +
                    (valeurRacine - Math.sqrt(operande)));
            extracteur.setPrecision(0.00001);
            valeurRacine = extracteur.racine(operande);
            System.out.println(valeurRacine);
            System.out.println("precision " + extracteur.getPrecision() + " , erreur =" +
                    (valeurRacine - Math.sqrt(operande)));
        } catch (OperandeNegatif|NumberFormatException e) {
            System.out.println(e.getMessage());
        }
    }
}