package moyenneException;

/**
 * Calcul d'une racine
 * @author Adrien Poupa
 */
public class Racine {
    private double precision;

    /**
     * Constructeur
     * @param precision précision à utiliser
     */
    Racine(double precision)
    {
        this.precision=precision;
    }

    /**
     * Calcul de la racine
     * @param operande utilisé
     * @return racine calculée
     * @throws OperandeNegatif en cas d'opérateur négatif
     */
    double racine (double operande)
            throws OperandeNegatif
    {
        if (operande < 0) {
            throw new OperandeNegatif(operande);
        }
        double solution, carre, a, b;
        a=0;
        b=operande;
        solution=(a+b)/2;
        while(b-a>precision)
        {
            carre=solution*solution;
            if (carre>operande) b=solution;
            else a=solution;
            solution=(a+b)/2;
        }
        return solution;
    }

    /**
     * Précision utilisée
     * @return double précision
     */
    double getPrecision() { return precision; }

    /**
     * Mise à jour de la gestion utilisée
     * @param precision précision à utiliser
     */
    void setPrecision(double precision) { this.precision=precision; }
}
