package moyenneException;

/**
 * Exception jetée en cas d'opérande négatif
 * @author Adrien Poupa
 */
public class OperandeNegatif extends Exception {
    private double operande;

    /**
     * Constructeur de la classe
     * @param operande opérande causant l'erreur
     */
    public OperandeNegatif(double operande) {
        this.operande = operande;
    }

    /**
     * Affichage de l'erreur
     * @return Erreur : opérande négatif XXX
     */
    @Override
    public String getMessage() {
        return "Erreur : opérande négatif " + operande;
    }
}
