package moyenneException;

/**
 * Calcul d'une moyenne avec exceptions
 * @author Adrien Poupa
 */
public class MoyenneException {
    /**
     * Calcul de la moyenne
     * @param argv éléments à prendre en compte
     */
    public static void main(String[] argv) {

        try {
            if (argv.length <= 0) {
                throw new NumberFormatException("Il n'y a pas d'arguments");
            }
            int moyenne = moyenne(argv);
            System.out.println("La moyenne est " + moyenne);
        } catch (ArithmeticException|NumberFormatException e) {
            System.out.println(e.getMessage());
        }

    }

    /**
     * Calcul de la moyenne
     * @param argv éléments à prendre en compte
     * @throws ArithmeticException si division par 0
     * @return moyenne
     */
    public static int moyenne(String[] argv)
            throws ArithmeticException {
        int somme = 0;
        int cpt = 0;
        for (int i = 0; i < argv.length; i++) {
            somme += Integer.parseInt(argv[i]);
            cpt++;
        }

        if (cpt == 0) {
            throw new ArithmeticException("Division par 0");
        }

        return somme / cpt;
    }
}
