package moyenneException;

/**
 * Test d'intervalle
 * @author Adrien Poupa
 */
public class InclusIntervalle {
    int borneInf, borneSup;

    /**
     * Vérification d'un intervalle
     * @param borneInf borne inférieure de l'intervalle
     * @param borneSup borne supérieure de l'intervalle
     * @throws ExceptionArgumentIncorrect en cas de borne inférieure supérieure à la borne supérieure
     */
    public InclusIntervalle(int borneInf, int borneSup)
            throws ExceptionArgumentIncorrect {
        if (borneInf > borneSup) {
            throw new ExceptionArgumentIncorrect(borneInf + ">=" + borneSup);
        }
        this.borneInf = borneInf;
        this.borneSup = borneSup;
    }
}
