package football;

/**
 * Test de la comparaison des salaires
 * @author Adrien Poupa
 */
public class TestComparaisonSalaires {
    /**
     * On crée deux équipes, on fait une nouvelle partie et on trie les joueurs de chaque équipe par salaire ascendant
     * @param argv arguments par défaut
     */
    public static void main(String[] argv) {
        Joueur quiEstLaTaupe = new Joueur("Evra", "Patrice", 34, 48418741, "Equipe de France");
        Joueur frankenstein = new Joueur("Ribery", "Franck", 32, 48418741, "Equipe de France");
        Joueur fragile = new Joueur("Gourcuff", "Yoann", 29, 48418741, "Equipe de France");
        Joueur fragile2 = new Joueur("Diaby", "Abou", 29, 48418741, "Equipe de France");
        Joueur mcDo = new Joueur("Gignac", "André-Pierre", 30, 42591, "Equipe de France");
        Joueur manoDeDios = new Joueur("Henry", "Thierry", 38, 48418741, "Equipe de France");
        Joueur dieudonne = new Joueur("Anelka", "Nicolas", 36, 48741, "Equipe de France");
        Joueur sextape = new Joueur("Benzema", "Karim", 28, 418741, "Equipe de France");
        Joueur dallas = new Joueur("Gallas", "William", 38, 44841, "Equipe de France");
        Joueur passoire = new Joueur("Lloris", "Hugo", 29, 48418741, "Equipe de France");
        Joueur bicyclette = new Joueur("Valbuena", "Mathieu", 31, 48418741, "Equipe de France");

        Equipe equipeDeFrance = new Equipe("Equipe de France");
        try {
            equipeDeFrance.ajout(quiEstLaTaupe);
            equipeDeFrance.ajout(frankenstein);
            equipeDeFrance.ajout(fragile);
            equipeDeFrance.ajout(fragile2);
            equipeDeFrance.ajout(mcDo);
            equipeDeFrance.ajout(manoDeDios);
            equipeDeFrance.ajout(dieudonne);
            equipeDeFrance.ajout(sextape);
            equipeDeFrance.ajout(dallas);
            equipeDeFrance.ajout(passoire);
            equipeDeFrance.ajout(bicyclette);
        } catch (EquipePleineException | JoueurHorsClubEquipeException e) {
            System.out.println(e.getMessage());
        }

        equipeDeFrance.triSalaire();
        System.out.println(equipeDeFrance.toString());

        Joueur perez = new Joueur("Perez", "Oscar", 34, 48418741, "Equipe du Mexique");
        Joueur juarez = new Joueur("Juarez", "Eduardo", 32, 48418741, "Equipe du Mexique");
        Joueur osorio = new Joueur("Osorio", "Ricardo", 29, 48418741, "Equipe du Mexique");
        Joueur rodriguez = new Joueur("Rodriguez", "Fernando", 29, 48418741, "Equipe du Mexique");
        Joueur salcido = new Joueur("Salcido", "Carlos", 30, 48418741, "Equipe du Mexique");
        Joueur hernandez = new Joueur("Hernandez", "Carlos", 30, 48418741, "Equipe du Mexique");
        Joueur blanco = new Joueur("Blanco", "Carlos", 30, 48418741, "Equipe du Mexique");

        Equipe equipeduMexique = new Equipe("Equipe du Mexique");
        try {
            equipeduMexique.ajout(perez);
            equipeduMexique.ajout(juarez);
            equipeduMexique.ajout(osorio);
            equipeduMexique.ajout(rodriguez);
            equipeduMexique.ajout(salcido);
            equipeduMexique.ajout(hernandez);
            equipeduMexique.ajout(blanco);
        } catch (EquipePleineException|JoueurHorsClubEquipeException e) {
            System.out.println(e.getMessage());
        }

        Arbitre arbitre = new Arbitre("Al Ghamdi", "Khalil Ibrahim", 35, 3);

        equipeDeFrance.triSalaire();
        equipeduMexique.triSalaire();

        Partie franceMexique = new Partie(arbitre, equipeDeFrance, equipeduMexique);

        arbitre.setPartie(franceMexique);

        System.out.println(franceMexique.toString());
    }
}
