package football;

import java.util.Arrays;

/**
 * Classe Partie, regroupe des joueurs et un arbitre
 * @author Adrien Poupa
 */
public class Partie {
    Arbitre arbitre;
    int[] score;
    Equipe[] equipes;

    /**
     * Constructeur d'une partie
     * @param arbitre Arbitre du match
     * @param equipe1 Première équipe
     * @param equipe2 Seconde équipe
     */
    public Partie(Arbitre arbitre, Equipe equipe1, Equipe equipe2) {
        this.arbitre = arbitre;
        score = new int[2];
        score[0] = 0;
        score[1] = 0;
        equipes = new Equipe[2];
        equipes[0] = equipe1;
        equipes[1] = equipe2;
        arbitre.setPartie(this); // Attribution de la partie actuelle à l'arbitre
    }

    /**
     * Un joueur marque un but : on incrémente le score de son équipe
     * @param joueur Joueur buteur
     */
    public void marquerUnBut(Joueur joueur) {
        if (joueur.equipe == equipes[0]) {
            score[0]++;
        } else {
            score[1]++;
        }
    }

    /**
     * Affichage de la partie
     * @return Partie à afficher
     */
    @Override
    public String toString() {
        return "Partie{" +
                "arbitre=" + arbitre +
                ", score=" + Arrays.toString(score) +
                ", equipes=" + Arrays.toString(equipes) +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet à comparer
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Partie partie = (Partie) o;

        if (arbitre != null ? !arbitre.equals(partie.arbitre) : partie.arbitre != null) return false;
        if (!Arrays.equals(score, partie.score)) return false;
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return Arrays.equals(equipes, partie.equipes);

    }

    /**
     * Surcharge de hashCode
     * @return hash int unique
     */
    @Override
    public int hashCode() {
        int result = arbitre != null ? arbitre.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(score);
        result = 31 * result + Arrays.hashCode(equipes);
        return result;
    }
}
