package football;

/**
 * Exception Joueur hors équipe
 * @author Adrien Poupa
 */
public class JoueurHorsEquipeException extends Exception {
    private String joueur;

    /**
     * Constructeur de l'exception
     * @param joueur Joueur n'étant pas dans l'équipe
     */
    public JoueurHorsEquipeException(String joueur) {
        this.joueur = joueur;
    }

    /**
     * Message à renvoyer
     * @return Message X ne fait pas partie de l'équipe
     */
    @Override
    public String getMessage() {
        return joueur + " ne fait pas partie de l'équipe!";
    }
}
