package football;

/**
 * Classe joueur
 * @author Adrien Poupa
 */
public class Joueur extends Acteur {
    // Visibilité package: aucun mot clé utilisé
    String club;
    double euroMillions;
    Equipe equipe;
    final double pourcentage;

    /**
     * Constructeur du joueur
     * @param nom nom du joueur
     * @param prenom prénom du joueur
     * @param age âge du joueur
     * @param euroMillions salaire du joueur
     * @param club club du joueur
     */
    public Joueur(String nom, String prenom, int age, double euroMillions, String club) {
        super(nom, prenom, age);
        this.club = club;
        this.euroMillions = euroMillions;
        pourcentage = Math.random(); // On fixe le pourcentage une fois pour toute, sinon on ne peut pas comparer, la valeur changeant à chaque fois...
    }

    /**
     * Constructeur du joueur, si pas de club : Knysa!
     * @param nom nom du joueur
     * @param prenom prénom du joueur
     * @param age âge du joueur
     * @param euroMillions salaire du joueur
     */
    public Joueur(String nom, String prenom, int age, double euroMillions) {
        this(nom, prenom, age, euroMillions, "Knysa Syndrome Club");
    }

    /**
     * Retourne le club du joueur
     * @return nom du club
     */
    public String getClub() {
        return club;
    }

    /**
     * Salaire du joueur, euroMillions * pourcentage
     * @return Salaire du joueur
     */
    public double getSalaire() {
        return euroMillions * pourcentage;
    }

    /**
     * Retourne l'équipe du joueur
     * @return objet équipe du joueur
     */
    public Equipe getEquipe() {
        return equipe;
    }

    /**
     * Affichage du joueur
     * @return Joueur à afficher
     */
    @Override
    public String toString() {
        return "Joueur{" +
                "nom='" + getNom() + '\'' +
                ", prenom='" + getPrenom() + '\'' +
                ", age='" + getAge() + '\'' +
                ", salaire='" + getSalaire() + '\'' +
                ", club='" + getClub() + '\'' +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet à comparer
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        Joueur joueur = (Joueur) o;

        if (Double.compare(joueur.euroMillions, euroMillions) != 0) return false;
        if (!getClub().equals(joueur.getClub())) return false;
        return getEquipe() != null ? getEquipe().equals(joueur.getEquipe()) : joueur.getEquipe() == null;

    }

    /**
     * Surcharge de hashCode
     * @return hash int unique
     */
    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp;
        result = 31 * result + getClub().hashCode();
        temp = Double.doubleToLongBits(euroMillions);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (getEquipe() != null ? getEquipe().hashCode() : 0);
        return result;
    }
}
