package football;

/**
 * Classe arbitre d'une partie
 * @author Adrien Poupa
 */
public class Arbitre extends Acteur {
    int degreExperience;
    Partie partie;

    /**
     * Constructeur de l'arbitre
     * @param nom nom de l'arbitre
     * @param prenom prénom de l'arbitre
     * @param age âge de l'arbitre
     * @param degreExperience degré d'expérience de l'arbitre
     */
    public Arbitre(String nom, String prenom, int age, int degreExperience) {
        super(nom, prenom, age);
        this.degreExperience = degreExperience;
    }

    /**
     * Salaire de l'arbitre
     * @return Salaire de l'arbitre
     */
    public double getSalaire() {
        return 0.1*Math.random()*degreExperience;
    }

    /**
     * Conversion du degré d'expérience int en String
     * @return chaîne de caractères du degré d'expérience
     */
    public String getExperience() {
        if (degreExperience == 1) {
            return "Débutant";
        }
        else if (degreExperience == 2) {
            return "Confirmé";
        }
        else {
            return "Expert";
        }
    }

    /**
     * Attribution d'une partie à un arbitre
     * @param partie partie à attribuer
     */
    public void setPartie(Partie partie) {
        this.partie = partie;
    }

    /**
     * Fonction valider un but
     * Que faire ?
     * @param joueur Joueur qui a marqué
     */
    public void validerUnBut(Joueur joueur) {

    }

    /**
     * Expulsion d'un joueur
     * @param joueur Joueur à supprimer
     * @throws JoueurHorsEquipeException si on essaie de supprimer un joueur qui n'est pas dans l'équipe
     */
    public void expulserUnJoueur(Joueur joueur)
        throws JoueurHorsEquipeException{
        if (partie.equipes[0].container.contains(joueur)) {
            partie.equipes[0].container.remove(joueur);
        } else if (partie.equipes[1].container.contains(joueur)) {
            partie.equipes[1].container.remove(joueur);
        } else {
            throw new JoueurHorsEquipeException(joueur.getNom());
        }
    }

    /**
     * Affichage de l'arbitre
     * @return Arbitre à afficher
     */
    @Override
    public String toString() {
        return "Arbitre{" +
                "nom='" + getNom() + '\'' +
                ", prenom='" + getPrenom() + '\'' +
                ", age='" + getAge() + '\'' +
                ", salaire='" + getSalaire() + '\'' +
                ", expérience='" + getExperience() + '\'' +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet à comparer
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        Arbitre arbitre = (Arbitre) o;

        if (degreExperience != arbitre.degreExperience) return false;
        return partie != null ? partie.equals(arbitre.partie) : arbitre.partie == null;

    }

    /**
     * Surcharge de hashCode
     * @return hash int unique
     */
    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + degreExperience;
        result = 31 * result + (partie != null ? partie.hashCode() : 0);
        return result;
    }
}
