package football;

/**
 * Classe abstraite Acteur
 * @author Adrien Poupa
 */
abstract public class Acteur {
    private final String nom;
    private final String prenom;
    private int age;

    /**
     * Constructeur de base acteur
     * @param nom Nom de l'acteur
     * @param prenom Prénom de l'acteur
     * @param age Age de l'acteur
     */
    public Acteur(String nom, String prenom, int age) {
        this.nom = nom;
        this.prenom = prenom;
        this.age = age;
    }

    /**
     * Salaire de l'acteur (arbitre ou joueur)
     * @return double salaire
     */
    abstract public double getSalaire();

    /**
     * Nom de l'acteur
     * @return nom de l'acteur
     */
    public String getNom() {
        return nom;
    }

    /**
     * Prénom de l'acteur
     * @return prénom de l'acteur
     */
    public String getPrenom() {
        return prenom;
    }

    /**
     * Age de l'acteur
     * @return age de l'acteur
     */
    public int getAge() {
        return age;
    }

    /**
     * Définition de l'age de l'acteur
     * @param age Nouvel age
     */
    public void setAge(int age) {
        this.age = age;
    }

    /**
     * Affichage générique de l'acteur
     * @return Acteur à afficher
     */
    @Override
    public String toString() {
        return "Acteur{" +
                "nom='" + nom + '\'' +
                ", prenom='" + prenom + '\'' +
                ", age='" + age + '\'' +
                ", salaire=" + getSalaire() +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet à comparer
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Acteur acteur = (Acteur) o;

        if (getAge() != acteur.getAge()) return false;
        if (!getNom().equals(acteur.getNom())) return false;
        return getPrenom().equals(acteur.getPrenom());

    }

    /**
     * Surcharge de hashCode
     * @return hash int unique
     */
    @Override
    public int hashCode() {
        int result = getNom().hashCode();
        result = 31 * result + getPrenom().hashCode();
        result = 31 * result + getAge();
        return result;
    }
}
