package automobile;

import java.util.Comparator;

/**
 * Interface permettant le sucre syntaxique dans Garage1
 * Exemple : Collections.sort(list, VehiculeComparator.IMMATRICULATION_ORDER)
 */
public interface VehiculeComparator {
    /**
     * Comparateur selon l'immatriculation
     * On utilise la fonction présente dans Véhicule
     */
    static final Comparator<Vehicule> IMMATRICULATION_ORDER = new Comparator<Vehicule>() {
        @Override
        public int compare(Vehicule o1, Vehicule o2) {
            return o1.compareTo(o2);
        }
    };

    /**
     * Comparateur selon le compteur
     * Comme dans GarageTriCompteur précédemment, on récupère les totaux des compteurs et on compare
     * Retour de 1 si le compteur de a est supérieur au compteur de b, -1 s'il est inférieur, 0 si égal
     */
    static final Comparator<Vehicule> COMPTEUR_ORDER = new Comparator<Vehicule>() {
        @Override
        public int compare(Vehicule o1, Vehicule o2) {
            int compteurA = o1.getCompteur().getTotalisateur();
            int compteurB = o2.getCompteur().getTotalisateur();
            if (compteurA > compteurB) {
                return 1;
            }
            else if (compteurA < compteurB) {
                return -1;
            }
            return 0;
        }
    };

    /**
     * Comparateur selon la jauge
     * Fonctionnement identique au comparateur des compteurs
     */
    static final Comparator<Vehicule> JAUGE_ORDER = new Comparator<Vehicule>() {
        @Override
        public int compare(Vehicule o1, Vehicule o2) {
            double jaugeA = o1.getJauge();
            double jaugeB = o2.getJauge();
            if (jaugeA > jaugeB) {
                return 1;
            }
            else if (jaugeA < jaugeB) {
                return -1;
            }
            return 0;
        }
    };
}
