package automobile;

import java.util.Comparator;

/**
 * Permet le tri de voitures en fonction des immatriculations (typo dans le nom de la fonction...)
 * Implémente Comparator de Vehicule
 * @author Adrien Poupa
 */
public class GarageTriImmatriculion implements Comparator<Vehicule> {
    /**
     * Comparaison de deux voitures, tri par rapport à leur numéro d'immatriculation
     * On réutilise la classe compareTo présente dans Véhicule
     * @param a Première voiture à tester
     * @param b Seconde voiture à tester
     * @return 1 si le compteur de a est supérieur au compteur de b, -1 s'il est inférieur, 0 si égal
     */
    @Override
    public int compare(Vehicule a, Vehicule b) {
        return a.compareTo(b);
    }
}
