package zoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Classe utilisée pour tout l'exercice 1 et 2 sur les animaux
 */
public class Utilisation {

    public static void main (String args[]){
        Chien monChien  = new Chien("Medor", 40, "Adrien");

        System.out.println("Premier affichage");
        System.out.println(monChien.toString());
        System.out.println(monChien.manger());

        // Il n'est plus possible de déclarer un animal, puisque la classe est désormais abstraite
        //Animal elephant = new Animal(1000, "Babar");

        Chien idefix = new Chien("Idefix", 50, "Obelix");
        Chien crocBlanc = new Chien("Croc-blanc", 45, "Jack London");

        Chat garfield = new Chat("Garfield", 150, "John");

        // Liste en tableau
        Animal[] arrayAnimal = {monChien, /*elephant, */ idefix, crocBlanc, garfield};

        System.out.println("Boucle sur le array simple");
        for (Animal name : arrayAnimal) {
            System.out.println(name.toString());
            System.out.println(name.manger());
        }

        ArrayList<Animal> arrayListAnimal = new ArrayList();

        arrayListAnimal.add(monChien);
        //arrayListAnimal.add(elephant);
        arrayListAnimal.add(idefix);
        arrayListAnimal.add(crocBlanc);
        arrayListAnimal.add(garfield);

        System.out.println("Boucle sur le arrayList");
        for(int i = 0; i < arrayListAnimal.size(); i++) {
            System.out.println(arrayListAnimal.get(i));
            System.out.println(arrayListAnimal.get(i).manger());
        }

        List<Animal> linkedListAnimal = new LinkedList();
        linkedListAnimal.add(monChien);
        //linkedListAnimal.add(elephant);
        linkedListAnimal.add(idefix);
        linkedListAnimal.add(crocBlanc);
        linkedListAnimal.add(garfield);

        System.out.println("Boucle sur la linkedList");
        for(int i = 0; i < linkedListAnimal.size(); i++) {
            System.out.println(linkedListAnimal.get(i));
            System.out.println(linkedListAnimal.get(i).manger());
        }

        // Dernière partie : container Zoo
        Zoo zooDeVincennes = new Zoo();

        zooDeVincennes.ajouter(monChien);
        zooDeVincennes.ajouter(idefix);
        zooDeVincennes.ajouter(crocBlanc);
        zooDeVincennes.ajouter(garfield);

        System.out.println("Affichage du zoo");
        System.out.println(zooDeVincennes.toString());

        // Exercice 2
        // Question 1
        List list;
        if (args.length == 0)
            list = new ArrayList<String>();
        else
            list = new LinkedList<String>();
        for(String s:args)
            list.add(s);

        // Question 3
        List list2 = new ArrayList<String>();
        Collections.addAll(list2, args);
        for(int i=0; i<list2.size(); i++) {
            String s = (String)list2.get(i);
            System.out.printf("%s:%d\n", s, s.length()); // affichage de l'argument actuel et de sa taille
        }


    }
}
