package zoo;

import java.util.HashMap;

/**
 * Associe deux élements potentiellement de différente nature grâce à HashMap
 */
public class Pair<U, V> {

    private final U first;
    private final V second;

    /**
     * Constructeur de la pair
     * @param first premier élément de la paire
     * @param second second élément de la paire
     */
    public Pair(U first, V second) {
        this.first=first;
        this.second=second;
    }

    /**
     * Retourne le premier élément de la paire
     * @return premier élément de la paire
     */
    public U getFirst() {
        return first;
    }

    /**
     * Retourne le second élément de la paire
     * @return second élément de la paire
     */
    public V getSecond() {
        return second;
    }

    /**
     * Surcharge de toString
     * @return Premier élement Second élément
     */
    @Override
    public String toString() {
        return first + " " + second;
    }

    /**
     * Surcharge de equals
     * @param o Paire à tester
     * @return true/false suivant si les paires sont égales ou non
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Pair<?, ?> pair = (Pair<?, ?>) o;

        if (!first.equals(pair.first)) return false;
        return second.equals(pair.second);

    }

    /**
     * Surcharge de hashCode
     * @return chaîne unique caractérisant une paire
     */
    @Override
    public int hashCode() {
        int result = first.hashCode();
        result = 31 * result + second.hashCode();
        return result;
    }

    /**
     * Test de la classe
     * @param args argument passé (inutile)
     */
    public static void main (String args[]){
        HashMap<Pair<String,String>,String> map = new HashMap<Pair<String,String>,String>();
        map.put(new Pair<String,String>("jean-paul","sartre"),"mort");
        map.put(new Pair<String,String>("elvis","presley"),"vivant");
        map.remove(new Pair<String,String>("elvis","presley")); // manque equals et hashCode, n'était pas supprimé sans
        System.out.println(map);
    }
}