package zoo;

import java.util.LinkedList;

/**
 * Classe PolyLine sans limitation de taille.
 */
public class FreePolyLine {

    private LinkedList<Point> points;

    /**
     * Constructeur de la PolyLine; initialisation du tableau de Points
     */
    public FreePolyLine() {
        points = new LinkedList<Point>();
    }

    /**
     * Ajout de point
     * @param p point à ajouter
     * @return true/false suivant si le point est inséré
     */
    public boolean add(Point p) {
        if (p != null) {
            System.out.println("Insertion de " + p.toString());
            points.add(p);
            return true;
        }
        else {
            System.out.println("p ne doit pas etre nul");
        }
        return false;
    }

    /**
     * Renvoie la capacité maximum de linkedList: infinité
     * @return POSITIVE_INFINITY
     */
    public double pointCapacity() {
        return Double.POSITIVE_INFINITY;
    }

    /**
     * Compte le nombre de points dans la liste
     * @return nombre de points dans la liste
     */
    public int pointCount(){
        return points.size();
    }

    /**
     * Surcharge de toString
     * Affichage du contenu de la liste de points
     * @return PolyLine{points=...}
     */
    @Override
    public String toString() {
        return "FreePolyLine{" +
                "points=" + points +
                '}';
    }

    /**
     * Vérification de l'existence d'un point dans la liste
     * @param p Point à vérifier
     * @return true/false
     */
    public boolean contains(Point p) {
        return points.contains(p);
    }
}
