package zoo;

/**
 * Chien, affiche des information sur un chien son maitre en particulier. Etend Animal
 */
public class Chien extends Animal {

    private String maitre;

    /**
     * Constructeur pour les 3 attributs d'un chien
     * @param poids poids du chien
     * @param nom du chien
     * @param maitre du chien
     */
    public Chien(String nom, int poids, String maitre) {
        super(poids, nom);
        this.maitre = maitre;
    }

    /**
     * Getter de Maitre
     * @return maitre
     */
    public String getMaitre() {
        return maitre;
    }

    /**
     * Setter de Maitre
     * @param maitre maitre
     */
    public void setMaitre(String maitre) {
        this.maitre = maitre;
    }

    /**
     * Surcharge de toString
     * @return Chien(maitre=..., poids=..., nom=...)
     */
    @Override
    public String toString() {
        return "Chien{" +
                "nom='" + getNom() + '\'' +
                ", maitre='" + maitre + '\'' +
                ", poids=" + getPoids() +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet de type Chien
     * @return true/false suivant si les objets sont égaux
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        Chien chien = (Chien) o;

        return maitre.equals(chien.maitre);

    }

    /**
     * Surcharge de hashCode
     * @return Chaîne unique de Chien
     */
    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + maitre.hashCode();
        return result;
    }

    /**
     * Implémentation de manger
     * @return Le chat mange du Ronron
     */
    public String manger() {
        return "Le chien mange du Pal"; // no comment
    }
}
