package zoo;

/**
 * Chat, affiche des information sur un chat, sa race en particulier. Etend Animal
 */
public class Chat extends Animal {

    private String race;

    /**
     * Constructeur de Chat
     * @param nom nom du chat
     * @param poids poids du chat
     * @param race race du chat
     */
    public Chat(String nom, int poids, String race) {
        super(poids, nom);
        this.race = race;
    }

    /**
     * Getter pour race
     * @return race du chat
     */
    public String getRace() {
        return race;
    }

    /**
     * Setter pour race
     * @param race rache du chat
     */
    public void setRace(String race) {
        this.race = race;
    }

    /**
     * Surcharge de equals
     * @param o objet de type Chat
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        Chat chat = (Chat) o;

        return race.equals(chat.race);

    }

    /**
     * Surcharge de hashCode
     * @return hash unique de Chat
     */
    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + race.hashCode();
        return result;
    }

    /**
     * Surcharge de toString
     * @return Chat(nopm=..., race=..., poids=...)
     */
    @Override
    public String toString() {
        return "Chat{" +
                "nom='" + getNom() + '\'' +
                ", race='" + race + '\'' +
                ", poids=" + getPoids() +
                '}';
    }

    /**
     * Implémentation de manger
     * @return Le chat mange du Ronron
     */
    public String manger() {
        return "Le chat mange du Ronron"; // no comment
    }
}
