package zoo;

/**
 * Classe Animal pour l'exercice 1, classe abstraite pour Chat et Chien
 */
abstract class Animal {

    private int poids;
    private String nom;

    /**
     * Constructeur par défaut, devenu inutile depuis que la classe est abstraite
     */
    public Animal() {
        this.poids = 0;
        this.nom = "Sans nom";
    }

    /**
     * Constructeur prenant deux paramètres, poids et nom, devenu inutile depuis que la classe est abstraite
     * @param poids de l'animal
     * @param nom de l'animal
     */
    public Animal(int poids, String nom) {
        this.poids = poids;
        this.nom = nom;
    }

    /**
     * Getter de Poids
     * @return poids de l'animal
     */
    public int getPoids() {
        return poids;
    }

    /**
     * Setter de Poids
     * @param poids de l'animal
     */
    public void setPoids(int poids) {
        this.poids = poids;
    }

    /**
     * Getter de Nom
     * @return nom de l'animal
     */
    public String getNom() {
        return nom;
    }

    /**
     * Setter de nom
     * @param nom de l'animal
     */
    public void setNom(String nom) {
        this.nom = nom;
    }

    /**
     * Surcharge de toString
     * @return Animal(poids=...,nom=...)
     */
    @Override
    public String toString() {
        return "Animal{" +
                "nom=" + nom +
                ", nom='" + poids + '\'' +
                '}';
    }

    /**
     * Surcharge de equals
     * @param o objet de type Animal
     * @return true/false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Animal animal = (Animal) o;

        if (poids != animal.poids) return false;
        return nom.equals(animal.nom);

    }

    /**
     * Surcharge de hashCode
     * @return Chaine unique d'Animal
     */
    @Override
    public int hashCode() {
        int result = poids;
        result = 31 * result + nom.hashCode();
        return result;
    }

    /**
     * Méthide abstraite manger
     * @return une phrase différente suivant la classe de l'objet
     */
    abstract public String manger();
}
