package tp6;

import java.util.ArrayList;

/**
 * Ajout de 5000 éléments par thread dans une ArrayList commune
 */
public class HelloListBug implements Runnable {

    private static ArrayList<Integer> array = new ArrayList<>();

    /**
     * Action effectuée par les threads: boucle de 5000 itérations insérant le compteur actuel dans l'ArrayList
     */
    public void run() {
        for(int i=0;i<5000;i++) {
            array.add(i);
        }
    }

    /**
     * Lancement de 4 threads effectuant la tâche définie plus haut
     * @param args Arguments par défaut
     */
    public static void main(String args[]) {

        Thread t0 = new Thread(new HelloListBug());
        t0.setName("0");

        Thread t1 = new Thread(new HelloListBug());
        t1.setName("1");

        Thread t2 = new Thread(new HelloListBug());
        t2.setName("2");

        Thread t3 = new Thread(new HelloListBug());
        t3.setName("3");

        t0.start();
        t1.start();
        t2.start();
        t3.start();

        try{
            t0.join();
            t1.join();
            t2.join();
            t3.join();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        System.out.println("Les threads ont fini de s'exécuter");
        System.out.println("Taille arrayList : " + array.size());

    }
}
