package etudiantsLangagesJTable.service;

import java.util.List;
import java.util.ArrayList;

import etudiantsLangagesJTable.domain.Etudiant;
import etudiantsLangagesJTable.domain.EtudiantLangage;


public class LangageService {
	private static LangageService instance;
	private List<EtudiantLangage> etudiantsLangages;

	/**
	 * Constructeur prive
	 */
	private LangageService() {
		super();
	}

	/**
	 * Singleton
	 * 
	 * @return
	 */
	public static synchronized LangageService getInstance() {
		if (instance == null) {
			instance = new LangageService();
		}

		return instance;
	}

	public synchronized List<EtudiantLangage> findEtudiantsLangages() {
		chargerDepuisBaseDeDonnees();
		return etudiantsLangages;
	}

	/**
	 * Bouchon.
	 * 
	 * Dans un vrai programme, ces donnees seraient chargees depuis la base.
	 */
	private void chargerDepuisBaseDeDonnees() {

		if (etudiantsLangages != null) {
			return;
		}

		etudiantsLangages = new ArrayList<EtudiantLangage>();

		// Etudiants (nom, prenom, langage)
		addEtudiantLangage("Durand", "Marie", "Java");
		addEtudiantLangage("Alesi", "Julie", "C");
		addEtudiantLangage("Martini", "Carine", "C");
		addEtudiantLangage("Labiche", "Lelou", "Java");
		addEtudiantLangage("Dujardin", "Anne",  "C");
		addEtudiantLangage("Laventure", "Martine",  "C");
		addEtudiantLangage("Livradu", "Alice","Java");
		addEtudiantLangage("Baladini", "Mathilde", "Java");
		addEtudiantLangage("Michelet", "Jean",  "C");
		addEtudiantLangage("Dupond", "Pierre", "Java");
		addEtudiantLangage("Timberot", "Martin", "C++");
		addEtudiantLangage("Gravatas", "Paul",  "C");
		addEtudiantLangage("De La Grange", "Luc","Java");
		addEtudiantLangage("Millot", "Bertrand", "C++");
		addEtudiantLangage("Herbert", "Franck",  "C");
		addEtudiantLangage("Dupontel", "Sylvain","Java");
		addEtudiantLangage("Avati", "Tom", "C++");
		addEtudiantLangage("Lidar", "Thierry",  "C++");
		addEtudiantLangage("Mo", "Francis",  "C++");
		addEtudiantLangage("Obino", "Alex",  "C++");
		addEtudiantLangage("Martin", "Julien",  "C++");;
		addEtudiantLangage("Balado", "Arnaud",  "C++");
		addEtudiantLangage("Loribo", "Paul", "Java");
		addEtudiantLangage("Allen", "Pierre",  "C++");
		addEtudiantLangage("Renaldino", "Yann", "Java");
		addEtudiantLangage("Margalev", "Vincent", "Java");
		addEtudiantLangage("Tong", "Hing",  "C++");
		addEtudiantLangage("Du Chemin", "Ludovic","Java");
		addEtudiantLangage("Denali", "Daniel", "Java");
		addEtudiantLangage("Maccimo", "Marcel", "Java");
		addEtudiantLangage("Formi", "Alexandre","Java");
		addEtudiantLangage("Malengo", "Tom",  "C++");
	}

	private void addEtudiantLangage(String nom, String prenom, String langage) {
		final Etudiant etudiant = new Etudiant(nom, prenom);
		final EtudiantLangage etudiantLangage = new EtudiantLangage(etudiant, langage);
		etudiantsLangages.add(etudiantLangage);
	}
}
