package etudiantsLangagesJTable.model;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import etudiantsLangagesJTable.domain.EtudiantLangage;
import etudiantsLangagesJTable.service.LangageService;


public class LangageModele extends AbstractTableModel {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -1944258978183994752L;

	private final String[] entetes = { "Nom", "Prenom", "Langage" };

	private LangageService langageService;

	private List<EtudiantLangage> etudiantsLangages;

	public LangageModele() {
		super();
		langageService = LangageService.getInstance();
		etudiantsLangages = langageService.findEtudiantsLangages();
	}

	@Override
	public int getColumnCount() {
		return entetes.length;
	}

	@Override
	public String getColumnName(int columnIndex) {
		return entetes[columnIndex];
	}

	@Override
	public int getRowCount() {
		return etudiantsLangages.size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		switch (columnIndex) {

		case 0:
			// Nom
			return etudiantsLangages.get(rowIndex).getEtudiant().getNom();

		case 1:
			// Prenom
			return etudiantsLangages.get(rowIndex).getEtudiant().getPrenom();

		case 2:
			// Langage prfr
			return etudiantsLangages.get(rowIndex).getLangage();

		default:
			throw new IllegalArgumentException();
		}
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		switch (columnIndex) {

		case 0:
		case 1:
			return String.class;
		case 2:
			return String.class;
		default:
			return Object.class;
		}
	}

	public List<EtudiantLangage> getEtudiantsLangages() {
		return etudiantsLangages;
	}
}
