package tp2;

import java.util.HashMap;
import java.util.Map;

public class Pair<U, V> {
    private final U first;
    private final V second;

    public Pair(U first, V second) {
      this.first=first;
      this.second=second;
    }
    public U getFirst() {
    	
      return first;
    }
    public V getSecond() {
      return second;
    }
    @Override
    public String toString() {
      return first+" "+second;
    }

	public static void main(String[] args) {
	    Map<Pair<String,String>,String> map=
	    	new HashMap<Pair<String,String>,String>();
	    map.put(new Pair<String,String>("jean-paul","sartre"),
	    		"mort");
	    map.put(new Pair<String,String>("elvis","presley"),
	    		"vivant");
	    map.remove(new Pair<String,String>("elvis","presley"));
	    System.out.println(map);
	     /* HashMap utilise hashCode() et equals() pour comparer les cls.
	     * La cl qu'on retire n'est donc pas gale  celle qu'on
	     * a mise. D'ailleurs, si on retire la cl avec la
	     * mme variable que celle qu'on utilise pour l'ajouter,
	     * a marche :
	    Pair<String,String> elvis =
	    	new Pair<String,String>("elvis","presley") ;
	    map.put(elvis, "vivant");
	    map.remove(elvis);
	    System.out.println(map);
	     * La solution est de redfinir equals() et hashCode() pour
	     * les Pair<U,V>. 
	     * */
	}
	/*
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((first == null) ? 0 : first.hashCode());
		result = prime * result + ((second == null) ? 0 : second.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Pair other = (Pair) obj;
		if (first == null) {
			if (other.first != null)
				return false;
		} else if (!first.equals(other.first))
			return false;
		if (second == null) {
			if (other.second != null)
				return false;
		} else if (!second.equals(other.second))
			return false;
		return true;
	}
	*/
}

