package singleton;

/**
 *  Les mthodes statiques sont souvent utiliss pour assurer l'unicit d'un objet
 *  Design Pattern : singleton
 */

public class Platform {
	private static final String NAME_PER_DEFAULT = "Java 8";
	
	// initialisation statique au chargement de la classe
	// ==> une seule instance
	private static Platform platform = new Platform(NAME_PER_DEFAULT);

	private String name;
	
	// Constructeur priv afin qu'un code client n'instancie pas plusieurs fois
	private Platform(String name){
		this.name = name;
	}
	
	// retourne l'unique instance par dfaut
	public static Platform getDefaultPlatform() {
		return platform;
	}

	@Override
	public String toString() {
		return "Platform [name=" + name + "]";
	}
}


