package concurrent;
import java.util.Date;

// NO THREAD-SAFE
public final class MyDateBug {
	private final Date startDate;
	private final Date endDate;
	
	public MyDateBug (Date startDate, Date endDate) {
		// PROBLEMES :
		// AUCUNE PROTECTION DES ACCES CONCURRENTS : 
		// un thread peut modifier les 2 paramtres et le test tre vrai
		if (startDate.compareTo(endDate) > 0) {
			throw new IllegalArgumentException("The start date is not <= the end date.");
		}
		
		// POUR EVITER LES EFFETS DE BORD via les paramtres
		// MAIS, on peut rcuprer des paramtres modifis via un thread
		this.startDate = (Date) startDate.clone();
		this.endDate = (Date) endDate.clone();
	}
	
	@Override
	public String toString() {
		return "MyDate [startDate=" + startDate + ", endDate=" + endDate + "]";
	}
}
