package concurrent;
import java.util.Date;


//THREAD-SAFE
public final class MyDate {
	private final Date startDate;
	private final Date endDate;
	
	public MyDate (Date startDate, Date endDate) {
		// POUR EVITER LES EFFETS DE BORD via les paramtres
		// ET SE PROTEGER DES ACCES CONCURRENTS
		startDate = (Date) startDate.clone();
		endDate = (Date) endDate.clone();
	
		if (startDate.compareTo(endDate) > 0) {
			throw new IllegalArgumentException("The start date is not <= the end date.");
		}
		
		// oprations atomiques pas besoin de synchronisation
		this.startDate = startDate;
		this.endDate = endDate;
	}
	
	@Override
	public String toString() {
		return "MyDate [startDate=" + startDate + ", endDate=" + endDate + "]";
	}
}

