package Exceptions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ClasseExemple3 {

	public static void main(String[] arg0){
		BufferedReader fluxEntree=null;
		String ligneLue;
		List<String> lignes = new ArrayList<String>();
		try{
			/* Le fichier /home/Bureau/fichier n'existe pas*/
			fluxEntree = new BufferedReader(new FileReader("//home//Bureau//fichier"));
			ligneLue = fluxEntree.readLine();
		}
		catch(IOException e1){
			/* Si on passe dans ce bloc, fluxEntree est à null
			 * Il y a eu une erreur à l'ouveture du fichier*/
			System.out.println("bloc IOException");
		}
		catch(NullPointerException e2){
			/* Si on passe dans ce bloc, le fichier est vide
			 * On n'a pas pu accéder à la première ligne*/
			System.out.println("bloc NullPointerException");
		}
		catch(Exception e3){
			/* On passera dans ce bloc pour toutes les autres exceptions*/
			System.out.println("bloc Exception");
		}
		finally{
			try{
				fluxEntree.close();
			}
			catch(IOException e1){
				/* On passe dans ce bloc si on 
				 * n 'arrive pas à fermer le fichier */
				System.out.println("bloc IOException 2");
			}
			catch(NullPointerException e2){
				/* On passe dans ce bloc si fichier est null */
				System.out.println("bloc NullPointerException 2");
			}
		}
	}
}
