package landschoot;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SpiderRobot extends Jouet {
	
	private int poids;

	public SpiderRobot(boolean edition, int kg) {
		specialEdition = edition;
		poids = kg; 
	}
	
	public int price(){
		return (5 * poids);
	}
	
	// copie dfensive
	public SpiderRobot copy()
	{
		return new SpiderRobot(this.specialEdition, this.poids);
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("spider robot ");
		sb.append(poids);
		sb.append(" kg ");
		sb.append(getSpecialEdition());
		return sb.toString();
	}


	public int getPoids() {
		return poids;
	}
	
	public void sort(List<SpiderRobot> spiderRobots)
	{
		Collections.sort(spiderRobots, IPoidsComparator.POIDS_ORDER);
	}
}
