package landschoot;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Packet extends Jouet implements Iterable<Jouet> {
	
	private List<Jouet> jouets;
	
	public Packet(){
		jouets = new LinkedList<Jouet> ();
	}

	// ajout d'une copie dfensive afin de ne pas partag des mmes jouets
	// dans des colis diffrents
	public void add(Jouet jouet) {
		jouets.add(jouet.copy());
	}

	public int numberOfItems() {
		return jouets.size();
	}
/*	
	public boolean isSpecialEdition(){
		boolean edition = true;
		ListIterator <Jouet> it = jouets.listIterator();
		while (it.hasNext()){
			edition = (it.next().isSpecialEdition() ? edition : false);
		}
		return edition;		
	}
*/
	public int price(){
		return this.totalPrice();
	}

	public int totalPrice() {
		int total = 0;
		/*ListIterator<Jouet> it = jouets.listIterator();
		while (it.hasNext()){
			total += it.next().price();
		}
		*/
		boolean edition = true;
		for (Jouet jouet : jouets) {
			if (jouet.specialEdition == false)
				edition = false;
			total += jouet.price();
		}
			
		total = ((edition == true) ? total - 20 : total);
		return total;
	}
	
	// copie dfensive
	public Packet copy()
	{
		Packet packet = new Packet();
		ListIterator<Jouet> it = jouets.listIterator();
		while (it.hasNext()){
			packet.add(it.next()); // ajout d'une copie dfensive d'un jouet
		}
		return packet;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("(");
		/*
		ListIterator<Jouet> it = jouets.listIterator();
		while (it.hasNext()){
			sb.append(it.next().toString());
			if (it.hasNext()) 
				sb.append(", ");	
		}
		sb.append(")");	
		*/
		
		for (Jouet jouet : jouets) {
			sb.append(jouet.toString() + "\n");
		}
		
		return sb.toString();
	}
	
	@Override
	public Iterator<Jouet> iterator() {
		return jouets.iterator();
	}

	public void sort()
	{
		Collections.sort(jouets);
	}
	
	public void sort(Comparator<SpiderRobot> comparator)
	{
		// copie superficielle de la liste de jouets dans une liste de robots
		// seules les rfrences des objets sont copies
		// ==> les instances sont partages
		List<SpiderRobot> spiderRobots = new LinkedList<SpiderRobot> ();
		for(Jouet jouet : jouets)
		{
			// on ne veut ajouter que des spiderRobot
			if (jouet instanceof SpiderRobot)
				spiderRobots.add((SpiderRobot)jouet);
		}
		// tri de la liste de robots par poids
		// ==> la liste de jouets est donc trie!
		Collections.sort(spiderRobots, comparator);
	}
}
