package landschoot;

public class LegoBricks extends Jouet {

	private int nbBricks;
	
	public LegoBricks(boolean edition, int n) {
		nbBricks = n;
		specialEdition = edition;
	}

	public int price() {
		return (10 * nbBricks) + (specialEdition ? 10 : 0);
	}
	
	// copie dfensive
	public Jouet copy()
	{
		return new LegoBricks(this.specialEdition, this.nbBricks);
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("LEGO ");
		sb.append(nbBricks);
		sb.append(" bricks");
		sb.append(getSpecialEdition());
		return sb.toString();
	}
}
