object myNewObject extends MyApplication {
  class Complex(val re: Double, val im: Double) {
    def add (that: Complex) =
      new Complex(re + that.re, im + that.im)

    def minus (that: Complex) =
      new Complex(re - that.re, im - that.im)

    def multiply (that: Complex) =
      new Complex(re * that.re - im * that.im,
        re * that.im + im * that.re)

    def divide (that: Complex) = {
      val denom = that.re * that.re + that.im * that.im
      new Complex((re * that.re + im * that.im) / denom,
        (im * that.re - re * that.im) / denom)
    }

    override def toString =
      re + (if (im < 0) "-" + (-im) else "+" + im) + "*i"
  }

  class NewComplex(val re: Double, val im: Double, val other: Complex) {
    def add (that: Complex) =
      new Complex(re + other.re + that.re, im + other.im + that.im)

    def minus (that: Complex) =
      new Complex(re - other.re - that.re, im - other.im - that.im)

    override def toString =
      re + (if (im < 0) "-" + (-im) else "+" + im) + "*i"

    override def clone = super.clone()
  }

  val x = new Complex(2, 1)
  val y = new Complex(1, 3)
  println(x + y)
  val newComplex = new NewComplex(1, 3, x)
}