grammar Scala;

MATH_OPERATOR: '+' | '-' | '/' | '*' | '<' | '>';
TYPE: 'Double' | 'Complex';
ARG_PREFIX_THAT: 'that';
ARG_PREFIX_VAL: 'val';
DEF : 'def';
NEW : 'new';
OBJECT : 'object';
EXTENDS : 'extends';
OVERRIDE : 'override';
CLASS : 'class';
CONDITION : 'if' | 'else';
WS : [ \r\n\t] -> skip;
ID : [a-zA-Z]+;
NUMBER : [0-9]+;

program : object*;

object: OBJECT ID EXTENDS ID '{' (class_def|val_def|call_function_def)* '}';

arg_function : ARG_PREFIX_THAT ': ' TYPE;

function_def : DEF (ID|MATH_OPERATOR) '(' arg_function (',' arg_function)* ') ='
                ('{' statements_function '}'|statements_function);
statements_function : (stmt_function)+;
stmt_function :  NEW (ID|TYPE) '(' ((expr_function)+) ')'
        | ARG_PREFIX_VAL ID '=' ((expr_function)+)
        ;

expr_function :  expr_function((MATH_OPERATOR|'.') expr_function)
        | '(' ((expr_function)+) ')'
        | ','
        | ID
        | ARG_PREFIX_THAT
        ;

arg_class : ARG_PREFIX_VAL ID ': ' TYPE;

class_def : CLASS (ID|TYPE) '(' arg_class (',' arg_class)* ')' '{'
            (function_def|override_def)* '}';

override_def : OVERRIDE DEF ID '=' (stmt_override)+;

stmt_override : (expr_override)+;

expr_override :  '(' ((expr_override)+) ')'
        | '"' ((expr_override)+) '"'
        | '.'
        | '()'
        | CONDITION
        | ID
        | NUMBER
        | MATH_OPERATOR
        ;

val_def : ARG_PREFIX_VAL ID '=' statements_val;

statements_val : (stmt_val)+;
stmt_val :  NEW (ID|TYPE) '(' ((expr_val)+) ')'
        ;

expr_val :  ','
            | ID
            | NUMBER
            ;

call_function_def : statements_call_function;

statements_call_function : (expr_call_function)+;

expr_call_function :  '(' (expr_call_function) ')'
        | expr_call_function (MATH_OPERATOR|'.') expr_call_function
        | ID
        | NUMBER
        | '()'
        ;